

NetFlow is a Cisco IOS XE Software feature designed to characterize network operations by collecting network traffic telemetry. It provides insights into network behavior, including application usage, resource utilization, impact of network changes, and detection of anomalies and security vulnerabilities.

### Understanding NetFlow

- **Purpose**: To understand "who, what, when, where, and how" network traffic is flowing.
- **Analogy**: Similar to a phone bill, providing details like who is talking to whom, over which protocols and ports, for how long, and at what speed.
- **Functionality**:
    - Pushes telemetry from network devices.
    - Provides high-level diagnostics for classifying network anomalies.
    - Detects attacks through behavioral changes in traffic.
- **Distinction from Packet Capture**: Unlike a sniffer that captures all traffic (like a wiretap), NetFlow provides summarized flow data (like a phone bill), enabling analysis engines (e.g., Cisco Secure Network Analytics, SIEM systems) to understand network activity.

### NetFlow Flow Definition

- **Packet Examination**: Each packet forwarded by a router or switch is examined for specific IP packet attributes.
- **Key Attributes (Standard NetFlow)**:
    1. Source IP address
    2. Destination IP address
    3. Source port
    4. Destination port
    5. Layer 3 protocol type
    6. Class of Service (CoS) or Type of Service (ToS) byte
    7. Input logical interface (ifIndex)
- **Flow Grouping**: Packets with identical values for these attributes are grouped into a "flow," and their packets and bytes are tallied.
- **NetFlow Cache**: This condensed NetFlow information is stored in a database called the NetFlow cache.
- **Unidirectional Flows**: IP flows collected by NetFlow are inherently unidirectional.
- **Flow Stitching**: Performed at the NetFlow collector, combines related unidirectional flows into a coherent bidirectional flow for complete visibility.
- **Deduplication**: Also performed at the NetFlow collector, eliminates redundant flow records collected from multiple points in the network, ensuring accuracy and optimizing analysis.
- **Endpoint Context (Cisco Secure Client NVM)**: NetFlow can be augmented with rich endpoint context (device type, user, application) from sources like Cisco Secure Client Network Visibility Module (NVM) for more actionable records.

### NetFlow Versions

Key NetFlow data export versions:

- **Version 1**: Original format, not used today.
- **Version 5**: Standard and most common; adds BGP, Autonomous System information, and flow sequence numbers.
- **Version 7**: Similar to version 5, but for Cisco Catalyst switches; does not include AS, interface, TCP flag, and ToS information.
- **Version 8**: Offers 11 aggregation schemes to reduce resource usage.
- **Version 9**: Dominant version today; flexible and extensible, template-based, self-describing, and independent of underlying transport protocol. Includes MPLS, multicast, and BGP next hop.

### NetFlow Version 9 Characteristics

- **Template-Based**: Templates define record formats (type and length of fields).
- **Communication**: Router sends template descriptions to the NetFlow Collection Engine; then sends flow records with minimal template information.
- **Transport Protocol Independence**: Can use UDP, TCP, etc.
- **Flow Record**: Follows the sequence of fields specified by the template definition, identified by a template ID.

### Types of Cisco NetFlow Implementations

- **Traditional Cisco IOS XE NetFlow**:
    - Configured per-interface.
    - Uses global collection policies.
    - Uses built-in collection templates.
    - Does not allow record customization.
- **Flexible Cisco IOS XE NetFlow**:
    - Second generation, offering greater flexibility and scalability.
    - Configured per-interface.
    - Uses per-interface collection policies.
    - Supports all built-in collection templates.
    - Allows full record customization and customizable data export.
- **Cisco Secure Firewall ASA NetFlow (NetFlow Secure Event Logging - NSEL)**:
    - Different from IOS XE; provides stateful IP flow tracking.
    - Exports records indicating significant events in a flow (e.g., `flow-create`, `flow-teardown`, `flow-denied`, `flow-update`).
    - Triggered by state changes or periodically (for byte counters).
    - **Major Functions**:
        - Filter NSEL events based on traffic and event type via Modular Policy Framework (MPF).
        - Send template information periodically to NSEL collectors.
        - Track configured NSEL collectors and deliver templates/data records via NetFlow over UDP only.
        - Define and export templates describing flow progression.
        - Track specific events (`flow-create`, `flow-teardown`, `flow-denied`) and generate NSEL data records.
    - **Benefits**: Supports events for permitted/denied flows, multiple export destinations, and offers more scalable performance than syslog.

### Applications of NetFlow Data

NetFlow data can be used for:

- Network management and planning
- Enterprise accounting and departmental chargebacks
- ISP billing
- Data warehousing and marketing
- Security and Denial of Service (DoS) monitoring
- Network monitoring
- Identifying network users and applications, peak usage times, and traffic routing.

### Cisco Secure Network Analytics (formerly Stealthwatch)

- A security analytics solution that collects telemetry from various sources (NetFlow, sFlow, Layer 7 protocols).
- Provides real-time visibility into network assets and profiles them.
- Correlates flows from multiple devices/interfaces and performs stitching and deduplication to provide a single bidirectional view of end-to-end traffic.
- For Cisco Secure Firewall Threat Defense, NSEL provides information on whether the flow was permitted or denied by the pre-filter policy and NAT details.

### Use Case: Configure Flexible NetFlow on Cisco IOS XE Devices

Three main tasks:

1. **Configure a Flexible NetFlow Exporter**:
    - Defines export destinations for NetFlow data.
    - Commands: `flow exporter MYEXPORTER`, `destination <IP>`, `transport udp <port>`, `export-protocol netflow-v9`.
2. **Configure a Flexible NetFlow Monitor**:
    - Defines which data is collected from network flows.
    - Commands: `flow monitor MYMONITOR`, `record netflow ipv4 original-input`, `exporter MYEXPORTER`.
3. **Apply the Flexible NetFlow Monitor to an Interface**:
    - Attaches the monitor to a network interface.
    - Command: `interface GigabitEthernet 0/1`, `ip flow monitor MYMONITOR input`.

### NetFlow Verification Commands (Cisco IOS XE)

- `show flow exporter statistics`: Shows export statistics for all exporters.
- `show flow monitor name <name> cache format table`: Shows contents of a specific monitor's cache.